/**********

serialv2.js
Communication module for GI-Proxy-v2.jar transparent serial to websocket proxy

** SERIAL PROXY

This module allows the user to connect with a serial port transparently; i.e.
everything sent to this websockets address will end up on the serial port in
that exact binary form, and everything the serial port sends to the proxy is 
sent, unaltered, to the websocket. 

** CONFIGURATION SERVER

Because we also want to be able to e.g. choose which serial port to connect 
to, inquire about available ports, etc., a second websocket connects to a
configuration server that runs in parallel and accepts JSON-formatted
commands. 

** NETWORK PORTS

The configuration server typically runs on port 8080, the transparent serial
port is piped by default over port 5331. Both of these can be changed in the
config.cfg file supplied with GI-Proxy-v2, and the websocket port for the 
transparent serial pipe can be changed via the configuration server.

** HOW TO USE

This modules is object-oriented:

var mySerialConnector = new SerialWebsocketProxy([config_address],[socket_address],[globalErrorCallback]);

If no address is given, DEFAULT_SOCKET_ADDR and DEFAULT_CONFIG_ADDR are used. 
Otherwise, use the method

mySerialConnector.setSocketAddress([errorcallback]) and .setConfigAddress([errorcallback])

After this, you can instruct the configuration server to request a list of
available serial ports. Because this is an asynchronous request, you have
to provide a callback function if you want to be notified when a response is
received. The notification calls your callback function with an array argument
containing the serial ports and the attached boards, if any is identified.

mySerialConnector.getCOMPortList(callback, [errorcallback])

returns

[["COM4",identifier, serial number],["COM5",identifier, serial number],...]

The identifier is a string returned by the board, usually "product name - version"
The serial number is an array of numbers representing the signature bytes of
an individual board, and is unique for all units across all products.

You can now connect to a board using that port name:

mySerialConnector.connect(String port, messageCallback, [errorcallback])

You now have a transparent pipe to the serial port. When data comes in over
serial, this gets sent to messageCallback as a Uint8Array in its first argument.
In order to send data, call

mySerialConnector.socketSend(Uint8Array data, [errorcallback])

That's it. Every function allows you to specify a unique callback, much like 
try...catch statements, but asynchronous. You can also specify a global error
callback using

mySerialConnector.setErrorCallback(callback)

Errors are always sent as a string in the first argument, then an error code
as a number. The error codes are documented below.

ERROR LIST
1	Configuration server connection failure


Accessible variables:



Todo:
- URL validator (that works for local stuff as well)

**********/



/*
function SerialWebsocketProxy(user_config_address, user_socket_address, user_error_callback){
	//version info
	MODULE_VERSION = 3;
	MODULE_BUILD = 1;
	MODULE_NAME = "serialv2.js";
	
	//defaults
	DEFAULT_SOCKET = "ws://localhost:5331";
	DEFAULT_CONFIG = "ws://localhost:8080";	
	this.globalErrorCallback = null;
	
	//other variables
	this.config = ""; this.socket = "";
	this.proxyConnected = false;		//variable tracking whether config is connected
	this.token = "";					//identifying token required for each transfer
	
	//user input
	this.socketAddress = typeof(user_socket_address) == "undefined" ? DEFAULT_SOCKET : user_socket_address;
	this.configAddress = typeof(user_config_address) == "undefined" ? DEFAULT_CONFIG : user_config_address;
	this.errorCallback = typeof(user_error_callback) == "undefined" ? this.defaultErrorCallback : user_error_callback;
	this.configMessageCallback = this.defaultConfigMessageCallback;
	
	// TODO: verify whether entered addresses are valid //
	
	//simple setter for this.socketAddress
	this.setSocketAddress = function(a){ this.socketAddress = a; }
	
	//simple setter for this.configAddress
	this.setConfigAddress = function(a){ this.configAddress = a; }
	
	//simple setter for this.errorCallback
	this.setErrorCallback = function(a){ this.errorCallback = a; }
	
	//this function queries the config server for a list of COM ports and throws the result to the specified callback
	this.getCOMPortList = function(callback){
		if(typeof(callback) == "function") this.configMessageCallback = callback;
	}
	
	//this function connects socket to a port
	this.connect = function(port, messageCallback){
	
	}
	
	this.socketSend(data){
	
	}
	
	this.connectToProxy = function(){
		this.config = new WebSocket(this.configAddress);
		
		this.config.onerror = function(e){
			proxyConnected = false;
			this.errorCallback(1,"Configuration server connection failure",e);
		}
		
		//this is pretty much static
		this.config.onmessage = function(msg){
			this.configMessageCallback(msg);
		}
	}
	
	this.defaultErrorCallback(code,message,error){
		alert("Error " + code + ": " + message + "\n" + error.message);
	}
	
	this.defaultConfigMessageCallback(msg){
		
	}
}


*/


//options
socket_addr = "ws://localhost:5331";
config_addr = "ws://localhost:8080";

//local variables
var socket;
var config;
var token = "";							//security token
var current_signature = "";
var firstMessage = false;				//boolean tracking whether any messages have been received on serial proxy

//global variables
var sensorobjects = new Array();
var sensorobjectindex;

var messagesReceived = 0;
var bytesReceived = 0;

//this function scans the serial ports and populates the serial devices list
//on completion, it goes to scancomplete()
function getSerialDevices(callback){
	firstMessage = true;
	if(socket) socket.close();
	if(config) config.close();

	socket = new WebSocket(socket_addr,'binary');
	socket.binaryType = "arraybuffer";
	config = new WebSocket(config_addr);
	
	socket.onerror = function(){error('Serial websocket proxy is not reachable',getSerialDevices,"Retry");}
	config.onerror = function(){error('Configuration server is not reachable',getSerialDevices,"Retry");}
	
	socket.onmessage = function(msg){
		last_socket_response = new Uint8Array(msg.data);
		messagesReceived++;
		bytesReceived += last_socket_response.length;
		if(firstMessage){
			//the first message is always the security token
			for(var i = 0; i < last_socket_response.length; i++){token += String.fromCharCode(last_socket_response[i]);}
			firstMessage = false;
				
			//token received, now we can do stuff with the configuration server
			config.send('{"c":1}');	//get list of ports
				
		} else if(!connected){
				
		}
	}
	
	config.onmessage = function(msg){	
		eval('var message = ' + msg.data);
		if(message.c == 1){	//list of COM ports			
			for(var i = 0; i < message.d.length; i++){
				sensorobjects[i] = [];
				sensorobjects[i][0] = message.d[i];				
			}
			if(sensorobjects.length){	//if the list is populated, start connecting
				sensorobjectindex = 0;
				config.send('{"c":10,"d":["' + sensorobjects[sensorobjectindex][0] + '"],"t":"' + token + '"}');
			} else {
				error('Did not detect any (virtual) serial ports.<br> Is your sensor plugged in? Make sure it is not in bootloader mode.',rescan,"Rescan");
			}
		}
		
		if(message.c == 10){ //tried connecting, but an error occurred
			sensorobjects[sensorobjectindex][1] = false;		//not connectable
			sensorobjects[sensorobjectindex][2] = message.e;	//store error code
			sensorobjects[sensorobjectindex][3] = message.m;	//store error message
			
			if(sensorobjectindex < sensorobjects.length - 1){ //see if more ports are available
				sensorobjectindex++;
				config.send('{"c":10,"d":["' + sensorobjects[sensorobjectindex][0] + '"],"t":"' + token + '"}');
			} else {
				scancomplete(callback);
			}
		}
		
		if(message.c == 0){ //success!
			sensorobjects[sensorobjectindex][1] = true;	//connectable
			if(sensorobjectindex < sensorobjects.length - 1){ //see if more ports are available
				sensorobjectindex++;
				config.send('{"c":10,"d":["' + sensorobjects[sensorobjectindex][0] + '"],"t":"' + token + '"}');
			} else {
				scancomplete(callback);
			}
		}
	}
	
	socket.onopen = function(){
		socket.send('');
	}
}

function rescan(){
	config.send('{"c":1}');
}

//this is where we arrive when the scan for devices has completed
//If no devices were found, we throw an error screen
//If 1 device was found, we connect to it and run the callback function on completion
//If more than 1 device was found, we connect to the first device and and run the callback function on completion
function scancomplete(callback){
	//iterate over the list of sensorobjects
	var num_connectable_objects = 0;
	var last_connectable_index = 0;
	for(i = 0; i < sensorobjects.length; i++){
		if(sensorobjects[i][1]){
			num_connectable_objects++;
			last_connectable_index = i;
		}
	}
	
	//we're going to connect to the first available sensor. Once it's connected, we want to get its signature
	config.onmessage = function(){
		socket.onmessage = function(msg){
			var d = new Uint8Array(msg.data);
			if(d.length == 13){	//we got the signature
				current_signature = toHex(d.subarray(0,-2));
				config.onmessage = function(){}	//and remove this handler
				if(typeof(callback) != "undefined") callback();
			}
		}
		socket.send('A');	//request signature
	}
	
	//if no connectable objects are available, throw an error message
	if(num_connectable_objects == 0){
		//in the error, we want descriptive error messages for every failure
		var errormessage = "";
		if(sensorobjects.length){	//if we found sensor objects, list all the error codes and messages
			errormessage += "Could not connect to sensor. The following error" + (sensorobjects.length > 1 ? "s" : "") + " occurred:\n";
			for(i = 0; i < sensorobjects.length; i++){
				errormessage += "(" + sensorobjects[i][0] + ") Error " + sensorobjects[i][2] + ": " + sensorobjects[i][3] + "\n";
			}
		} else {
			errormessage += "Could not find any serial ports. Are you sure the sensor is plugged in and not in bootloader mode?";
		}
		
		error(errormessage,getSerialDevices,"Rescan");
	}
	
	if(num_connectable_objects == 1){	//if exactly one sensor is attached, connect to that one
		if(last_connectable_index != (sensorobjects.length - 1)){ //unless we're already connected to it, in which case we do nothing
			config.send('{"c":10,"d":["' + sensorobjects[last_connectable_index][0] + '"],"t":"' + token + '"}');
		} else {	//we still want to fire the signature event
			socket.onmessage = function(msg){
				var d = new Uint8Array(msg.data);
				//alert("signature: " + d.length);
				if(d.length == 13){	//we got the signature
					current_signature = toHex(d.subarray(0,-2));
					config.onmessage = function(){}	//and remove this handler
					if(typeof(callback) != "undefined") callback();
				}
			}
			socket.send('A');	//request signature
		}
		connected = 1;
	}
	
	if(num_connectable_objects > 1){	//multiple sensors are attached to the computer. Which one do we choose?
		//unimplemented for now, it just connects to the last connectable sensor		
		if(last_connectable_index != (sensorobjects.length - 1)){ //unless we're already connected to it, in which case we do nothing
			config.send('{"c":10,"d":["' + sensorobjects[last_connectable_index][0] + '"],"t":"' + token + '"}');
		}		
		connected = 1;
	}
}


function connect(portobject, callback, messagecallback){ //makes websocket and starts scanning process	
	socket.onclose = function(){
		connected = 0;
	}
	socket.onerror = function(){		
		socket.close();
		config.close();
		error('Connection aborted unexpectedly. Try rescanning.',getSerialDevices,"Rescan");
	}
	
	socket.onmessage = function(msg){
		messagecallback(msg.data);
	}
	
	socket.onopen = function(){
		connect_active = 1;
		tick2(); //start visualization
		tick3(); //start connection speed gauge
		connected = 1;
		setTimeout(function(){callback()},250);
	}
}

function disconnect(){
	socket.send('F'); //stop autosend	
	connected = 0;	
	connect_active = 0;
	synced = 0;
	socket.close();
	config.close();
	time = 0;
}

//this function zero-pads a number to [positions] digits, i.e. it will turn '8' into '008'
function zeroPad(number, positions){
	var result = "";
	for(var i = positions - 1; i > -1; i--){
		result += "" + Math.floor(number / Math.pow(10,i));
		number -= Math.pow(10,i) * Math.floor(number / Math.pow(10,i));
	}
	return result;
}