//sgraph variables, sgraph is main realtime graph
var sgraph_options = {
	"background": "#ffffff",	//background color for entire graph
	"margins": {
		"subgraph": 70,
		"keepout": {			//background-color space around the entire graph, nothing is plotted here
			"top": 		20,
			"bottom": 	20,
			"left": 	20,
			"right": 	20
		},
		"axes": {				//how far the axes are from the side
			"top":		20,
			"left":	   100,
			"bottom": 	50,
			"right":	20
		}
	},
	"linestyle": [				//graph colors
		"#0000AA"
	],
	"linewidth": 2,			//graph linewidth
	"axis_color": "#444444",
	"axisdiv_color": "#999999",
	"subaxis_color": "#888888",
	"currentViewColor": "#89c3eb",
	"axis_width": 1,
	"ticklength": 20,
	"fast_retention":[			//how long each sample level should be preserved, in number of samples (fast data)
		625000,					//5 seconds 	at 125	kS/s
		625000,					//20 seconds 	at 32	kS/s
		625000,					//1 min 20 s 	at 7.8	kS/s
		625000,					//5 min 20 s	at 1.95	kS/s
		292969,					//10 min 		at 488	 S/s
		73242,					//10 min		at 122   S/s
		2636719,				//24 h			at 31    S/s
		2636719,					//additional zoom levels
		2636719,
		2636719,
		2636719
	],
	"slow_retention":[
		100000					//? at 50S/s
	]
}

var __global = {
	"autoconnect": false,
	"framerate": 15,
	"defaultPowerSource": "5Vin",	//AUX or 5Vin
	"defaultCurrentShunt": "highCurrent",
	"defaultDecimation": 0
}

var __calibration = {
	"345731303533151A000B00" : {
		"fast_B_offset" :  [[0,0],
							[2.067,	7.99e-6],
							[2.45,	13.6e-6],
							[2.994,	22.1e-6],
							[3.534,	30.9e-6],
							[4.045,	39.1e-6],
							[4.945,	54.2e-6],
							[5.4,	62.1e-6],
							[10,	100e-6]]
	},
	"345731303533090C000C00" : {
		"fast_B_offset" :  [[0,0],
							[1.94,	3.51e-6],
							[2.465,	10.1e-6],
							[3.04,	17.2e-6],
							[3.472,	22.8e-6],
							[3.981,	29.3e-6],
							[4.95,	42.7e-6],
							[5.39,	49.2e-6],
							[10,	100e-6]]
	},
	"3457313035330A16000200" : {
		"fast_B_offset" :  [[0,0],
							[2.022,	2.14e-6],
							[2.519,	9.3e-6],
							[3.044,	16.6e-6],
							[3.482,	23.3e-6],
							[4.015,	31.2e-6],
							[4.98,	46.8e-6],
							[5.39,	49.2e-6],
							[10,	100e-6]]
	},
	"3457313035330904001200" : {
		"fast_B_offset" :  [[0,0],
							[2.05,	5.1e-6],
							[2.481,	11.2e-6],
							[3.003,	17.9e-6],
							[3.49,	25.05e-6],
							[4.025,	33.1e-6],
							[4.944,	47e-6],
							[5.45,	55.1e-6],
							[10,	100e-6]]
	},
	"3258323035330506001900": {
		"fast_B_offset" : 	[[0,0],
							[2.05,	5.1e-6],
							[2.481,	11.2e-6],
							[3.003,	17.9e-6],
							[3.49,	25.05e-6],
							[4.025,	33.1e-6],
							[4.944,	47e-6],
							[5.45,	55.1e-6],
							[10,	100e-6]]
	}
}